﻿
namespace ProAzure.MachineInfo.Service
{
    using System;
    using System.Collections.Generic;
    using System.Collections.Specialized;
    using System.IO;
    using System.Linq;
    using System.Net;
    using System.ServiceModel;
    using System.ServiceModel.Description;
    using System.ServiceModel.Security;
    using System.ServiceModel.Web;
    using System.Text;
    using System.Web;

    /*
   Client issuer key: iEVAlclelnAsLoF4mn61PGH/xo1DR8l7F6bOAu6Pb1o=
Client issuer name: acsexample
Service Token Policy key: 8O++r46Eo6e6VhGQaHSCfINhYMMCu14xsAectW2EFfk=
     * */
    class Program
    {
        static string serviceNamespace;
        static string issuerKey;

        const string acsHostName = "accesscontrol.windows.net";
        const string issuerName = "acsexample";

        static void Main()
        {
            Console.WriteLine("Enter your solution name, then press <ENTER>");
            serviceNamespace = Console.ReadLine();
            
            Console.WriteLine();
            Console.WriteLine("Enter your issuer key, then press <ENTER>");
           // issuerKey = Console.ReadLine();
            issuerKey = "iEVAlclelnAsLoF4mn61PGH/xo1DR8l7F6bOAu6Pb1o=";
            // create a token with a group=user claim
            string userToken = GetUserToken();

            // send the token to ACS
            string acsIssuedToken = SendSWTToACS(userToken, "http://localhost/acsexample");

            // perform the calculator operations
            Console.WriteLine();
            Console.WriteLine("Calling calculator with 'group=user' claim");
            DoOperations(acsIssuedToken);

            // create a token with a group=user,executive claim
            string executiveToken = GetUserAdminToken();
            
            // send the token to ACS
            acsIssuedToken = SendSWTToACS(executiveToken, "http://localhost/acsexample");

            // perform the calculator operations
            Console.WriteLine();
            Console.WriteLine("Calling ACS Example with 'group=user,admin' claim");
            DoOperations(acsIssuedToken);

            Console.WriteLine();
            Console.WriteLine("Done. Press <ENTER> to end");
            Console.ReadLine();
        }

        private static void DoOperations(string userToken)
        {
            WebHttpBinding binding = new WebHttpBinding();
            Uri address = new Uri("http://localhost/acsexample");

            WebChannelFactory<IACSExample> factory = new WebChannelFactory<IACSExample>(binding, address);
            factory.Endpoint.Behaviors.Add(new WebHttpBehavior());

            IACSExample proxy = factory.CreateChannel();

            using (new OperationContextScope((IClientChannel)proxy))
            {
                WebOperationContext.Current.OutgoingRequest.Headers.Add(HttpRequestHeader.Authorization, userToken);

                try
                {
                    Console.Write("\tCalling GetMachineName: ");
                    Console.WriteLine("Machine Name is:" + proxy.GetMachineName());

                    Console.Write("\tCalling GetUserDomainName: ");
                    Console.WriteLine("User Domain Name is:" + proxy.GetUserDomainName());

                    Console.Write("\tCalling GetOSVersion: ");
                    Console.WriteLine("OS Version is:" + proxy.GetOSVersion());

                   
                    Console.Write("\tCalling EncodeString: ");
                    Console.WriteLine("Encoded String is:" + Encoding.UTF8.GetString( proxy.EncodeString("Welcome to ProAzure.")));
                }
                catch (MessageSecurityException ex)
                {
                    if (ex.InnerException != null && ex.InnerException.GetType() == typeof(WebException))
                    {
                        Console.WriteLine(ex.InnerException.Message);
                    }
                    else
                    {
                        throw; ;
                    }
                }
            }

            ((IClientChannel)proxy).Close();
        }

        static string GetUserAdminToken()
        {
            Dictionary<string, string> claims = new Dictionary<string, string>();
            claims.Add("group", "user,admin");

            TokenFactory factory = new TokenFactory(acsHostName, serviceNamespace, issuerName, issuerKey);
            return factory.CreateToken(claims);
        }

        static string GetUserToken()
        {
            Dictionary<string, string> claims = new Dictionary<string, string>();
            claims.Add("group", "user");

            TokenFactory factory = new TokenFactory(acsHostName, serviceNamespace, issuerName, issuerKey);
            return factory.CreateToken(claims);
        }

        static string SendSWTToACS(string swt, string appliesTo)
        {
            // request a token from ACS
            WebClient client = new WebClient();
            client.BaseAddress = string.Format(@"https://{0}.{1}/", serviceNamespace, acsHostName);

            NameValueCollection values = new NameValueCollection();
            values.Add("wrap_SWT", swt);
            values.Add("applies_to", appliesTo);

            string response = null;

            byte[] responseBytes = client.UploadValues("WRAPv0.8", values);
            response = Encoding.UTF8.GetString(responseBytes);

            return HttpUtility.UrlDecode(response
                .Split('&')
                .Single(value => value.StartsWith("wrap_token=", StringComparison.OrdinalIgnoreCase))
                .Split('=')[1]);
        }
    }
}
